/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.SetWrapper;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.opentest4j.AssertionFailedError;

class SetWrapperTest {
    SetWrapperTest() {
    }

    @Test
    public void methodsInvokeDelegateMethods() {
        Set delegate = (Set)Mockito.mock(Set.class);
        SetWrapper testInstance = new SetWrapper(delegate);
        MethodIterator methodIterator = new MethodIterator(Set.class, null);
        Iterable methods = () -> methodIterator;
        int methodCount = 0;
        for (Method method : methods) {
            if (Arrays.asHashSet((Object[])new String[]{"equals", "hashCode"}).contains(method.getName())) continue;
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                Object delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                Mockito.clearInvocations((Object[])new Set[]{delegate});
                ++methodCount;
            }
            catch (AssertionFailedError assertionFailedError) {
                throw new AssertionFailedError("method " + method.getName(), (Object)assertionFailedError.getExpected(), (Object)assertionFailedError.getActual());
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(14);
    }
}

